<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactPersonsTable extends Migration {

	public function up()
	{
		Schema::create('contact_persons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('company_id')->unsigned();
			$table->string('name');
			$table->string('employee_title');
			$table->string('phone');
			$table->string('email');
			$table->string('address')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contact_persons');
	}
}