<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMessagesTable extends Migration {

	public function up()
	{
		Schema::create('messages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('conversation_id')->unsigned();
			$table->bigInteger('sender_id')->unsigned();
			$table->string('message');
			$table->bigInteger('receiver_id')->unsigned();
			$table->tinyInteger('read')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('messages');
	}
}