<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Pegawai extends Model 
{

    protected $table = 'pegawai';
    public $timestamps = true;

    public function jabatan()
    {
        return $this->belongsTo('App\Jabatan', 'id');
    }

    public function golongan()
    {
        return $this->belongsTo('App\Golongan', 'id');
    }

    public function gaji()
    {
        return $this->hasMany('App\Gaji', 'pegawai_id');
    }

    public function jadwal_pelajaran()
    {
        return $this->hasMany('App\Jadwal_Pelajaran', 'pegawai_id');
    }

    public function pengajar()
    {
        return $this->hasMany('App\Pengajar', 'pegawai_id');
    }

    public function absen_pegawai()
    {
        return $this->hasMany('App\Absen_pegawai', 'pegawai_id');
    }

}