<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWaliMuridTable extends Migration {

	public function up()
	{
		Schema::create('wali_murid', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('murid_id')->unsigned();
			$table->integer('category_wali_id')->unsigned();
			$table->string('name', 50);
			$table->string('religion', 10);
			$table->integer('gender');
			$table->string('work', 50)->nullable();
			$table->string('email', 20)->nullable();
			$table->string('msisdn', 20)->nullable();
			$table->text('address');
			$table->integer('status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('wali_murid');
	}
}