<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('pegawai', function(Blueprint $table) {
			$table->foreign('golongan_id')->references('id')->on('golongan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('pegawai', function(Blueprint $table) {
			$table->foreign('jabatan_id')->references('id')->on('jabatan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('kelas', function(Blueprint $table) {
			$table->foreign('jurusan_id')->references('id')->on('jurusan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->foreign('kelas_id')->references('id')->on('kelas')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->foreign('mata_pelajaran_id')->references('id')->on('mata_pelajaran')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('gaji', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('gaji', function(Blueprint $table) {
			$table->foreign('golongan_id')->references('id')->on('golongan')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('murid', function(Blueprint $table) {
			$table->foreign('wali_murid_id')->references('id')->on('wali_murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('spp', function(Blueprint $table) {
			$table->foreign('murid_id')->references('id')->on('murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('wali_murid', function(Blueprint $table) {
			$table->foreign('murid_id')->references('id')->on('murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('wali_murid', function(Blueprint $table) {
			$table->foreign('category_wali_id')->references('id')->on('wali_murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('absen_murid', function(Blueprint $table) {
			$table->foreign('murid_id')->references('id')->on('murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('pengajar', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('pengajar', function(Blueprint $table) {
			$table->foreign('mata_pelajaran_id')->references('id')->on('mata_pelajaran')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('absen_pengajar', function(Blueprint $table) {
			$table->foreign('jadwal_pelajaran_id')->references('id')->on('jadwal_pelajaran')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('absen_pegawai', function(Blueprint $table) {
			$table->foreign('pegawai_id')->references('id')->on('pegawai')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nilai', function(Blueprint $table) {
			$table->foreign('murid_id')->references('id')->on('murid')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('nilai', function(Blueprint $table) {
			$table->foreign('category_nilai_id')->references('id')->on('category_nilai')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('pegawai', function(Blueprint $table) {
			$table->dropForeign('pegawai_golongan_id_foreign');
		});
		Schema::table('pegawai', function(Blueprint $table) {
			$table->dropForeign('pegawai_jabatan_id_foreign');
		});
		Schema::table('kelas', function(Blueprint $table) {
			$table->dropForeign('kelas_jurusan_id_foreign');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->dropForeign('jadwal_pelajaran_pegawai_id_foreign');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->dropForeign('jadwal_pelajaran_kelas_id_foreign');
		});
		Schema::table('jadwal_pelajaran', function(Blueprint $table) {
			$table->dropForeign('jadwal_pelajaran_mata_pelajaran_id_foreign');
		});
		Schema::table('gaji', function(Blueprint $table) {
			$table->dropForeign('gaji_pegawai_id_foreign');
		});
		Schema::table('gaji', function(Blueprint $table) {
			$table->dropForeign('gaji_golongan_id_foreign');
		});
		Schema::table('murid', function(Blueprint $table) {
			$table->dropForeign('murid_wali_murid_id_foreign');
		});
		Schema::table('spp', function(Blueprint $table) {
			$table->dropForeign('spp_murid_id_foreign');
		});
		Schema::table('wali_murid', function(Blueprint $table) {
			$table->dropForeign('wali_murid_murid_id_foreign');
		});
		Schema::table('wali_murid', function(Blueprint $table) {
			$table->dropForeign('wali_murid_category_wali_id_foreign');
		});
		Schema::table('absen_murid', function(Blueprint $table) {
			$table->dropForeign('absen_murid_murid_id_foreign');
		});
		Schema::table('pengajar', function(Blueprint $table) {
			$table->dropForeign('pengajar_pegawai_id_foreign');
		});
		Schema::table('pengajar', function(Blueprint $table) {
			$table->dropForeign('pengajar_mata_pelajaran_id_foreign');
		});
		Schema::table('absen_pengajar', function(Blueprint $table) {
			$table->dropForeign('absen_pengajar_jadwal_pelajaran_id_foreign');
		});
		Schema::table('absen_pegawai', function(Blueprint $table) {
			$table->dropForeign('absen_pegawai_pegawai_id_foreign');
		});
		Schema::table('nilai', function(Blueprint $table) {
			$table->dropForeign('nilai_murid_id_foreign');
		});
		Schema::table('nilai', function(Blueprint $table) {
			$table->dropForeign('nilai_category_nilai_id_foreign');
		});
	}
}