<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inquiry', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('inquiry', function(Blueprint $table) {
			$table->foreign('real_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('maintenance', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->foreign('landloard')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('categories_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenant', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('tenancy_contracts', function(Blueprint $table) {
			$table->foreign('property_id')->references('id')->on('property')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tenancy_contracts', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('tenant')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('checks', function(Blueprint $table) {
			$table->foreign('tenancy_contracts_id')->references('id')->on('tenancy_contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_id_foreign');
		});
		Schema::table('subscribe', function(Blueprint $table) {
			$table->dropForeign('subscribe_user_id_foreign');
		});
		Schema::table('inquiry', function(Blueprint $table) {
			$table->dropForeign('inquiry_user_id_foreign');
		});
		Schema::table('inquiry', function(Blueprint $table) {
			$table->dropForeign('inquiry_real_id_foreign');
		});
		Schema::table('maintenance', function(Blueprint $table) {
			$table->dropForeign('maintenance_user_id_foreign');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->dropForeign('property_landloard_foreign');
		});
		Schema::table('property', function(Blueprint $table) {
			$table->dropForeign('property_area_id_foreign');
		});
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_categories_id_foreign');
		});
		Schema::table('tenant', function(Blueprint $table) {
			$table->dropForeign('tenant_user_id_foreign');
		});
		Schema::table('tenancy_contracts', function(Blueprint $table) {
			$table->dropForeign('tenancy_contracts_property_id_foreign');
		});
		Schema::table('tenancy_contracts', function(Blueprint $table) {
			$table->dropForeign('tenancy_contracts_tenant_id_foreign');
		});
		Schema::table('checks', function(Blueprint $table) {
			$table->dropForeign('checks_tenancy_contracts_id_foreign');
		});
	}
}