<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trip extends Model 
{

    protected $table = 'trips';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function bus()
    {
        return $this->belongsTo('Bus');
    }

    public function driver()
    {
        return $this->belongsTo('Driver');
    }

    public function stations()
    {
        return $this->morphMany('Station');
    }

    public function journey()
    {
        return $this->hasMany('Journey');
    }

}