<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->json('blocked_trips');
			$table->bigInteger('journey_id')->unsigned();
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('launch_station_id')->unsigned();
			$table->bigInteger('arival_station_id')->unsigned();
			$table->timestamps();
			$table->bigInteger('seat_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}