<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractTable extends Migration {

	public function up()
	{
		Schema::create('contract', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->string('symbol')->nullable();
			$table->string('address')->nullable();
			$table->json('abi')->nullable();
			$table->string('base_uri')->nullable();
			$table->double('mint_price')->nullable();
			$table->integer('max_per_minute')->nullable();
			$table->integer('max_owned_per_wallet')->nullable();
			$table->double('presale_mint_price')->nullable();
			$table->integer('presale_max_per_wallet')->nullable();
			$table->integer('presale_max_owned_per_wallet')->nullable();
			$table->string('reveal_uri')->nullable();
			$table->integer('reserved_supply')->nullable();
			$table->integer('collection_id')->nullable();
			$table->boolean('is_testnet')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('contract');
	}
}