<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Coupon extends Model 
{

    protected $table = 'coupon';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('offer_id', 'number', 'name_en', 'name_ar', 'discount', 'description_en', 'description_ar', 'expired_at', 'status', 'max_uses', 'uses', 'current_uses');

    public function offer()
    {
        return $this->belongsTo('Offer', 'offer_id');
    }

    public function histories()
    {
        return $this->hasMany('CouponHistory', 'coupon_id');
    }

}