<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferTable extends Migration {

	public function up()
	{
		Schema::create('offer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('city_id')->nullable();
			$table->integer('category_id')->nullable();
			$table->integer('company_id')->nullable();
			$table->text('discounts_en')->nullable();
			$table->text('discounts_ar')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->boolean('have_coupons')->nullable()->default(0);
			$table->text('video')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('offer');
	}
}