<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Market extends Model 
{

    protected $table = 'markets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsToMany('User', 'user_id', 'market_id');
    }

    public function configs()
    {
        return $this->hasMany('MarketConfig', 'market_id');
    }

    public function items()
    {
        return $this->belongsToMany('Item', 'item_id', 'market_id');
    }

}