<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function markets()
    {
        return $this->belongsToMany('Market', 'market_id', 'user_id');
    }

    public function wallet()
    {
        return $this->hasOne('Wallet', 'user_id');
    }

    public function portfolio()
    {
        return $this->hasOne('Portfolio', 'user_id');
    }

}