<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePortfolioTable extends Migration {

	public function up()
	{
		Schema::create('portfolio', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('item_id')->unsigned();
			$table->integer('market_id')->unsigned();
			$table->integer('investment_positive');
			$table->integer('investment_negative');
			$table->integer('investment');
			$table->decimal('shares');
		});
	}

	public function down()
	{
		Schema::drop('portfolio');
	}
}