<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('coupon_type', 255)->nullable();
			$table->string('coupon_description', 255)->nullable();
			$table->datetime('valid_until');
			$table->integer('id_order')->unsigned();
			$table->float('percent');
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}