<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('reservations', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('doctor_id')->unsigned()->nullable();
			$table->enum('enable_tax', array('0', '1'));
			$table->string('tax')->nullable();
			$table->enum('discount', array('none', 'money', 'persentage'));
			$table->string('sub_total')->nullable();
			$table->string('total')->nullable();
			$table->string('status')->nullable();
			$table->string('payment_status')->nullable();
			$table->string('date')->nullable();
			$table->string('description')->nullable();
			$table->string('cancel_reason')->nullable();
			$table->string('payment_type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reservations');
	}
}