<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('commissions', function(Blueprint $table) {
			$table->foreign('westoyv_id')->references('id')->on('westoyvs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->foreign('personnel_id')->references('id')->on('personnels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->foreign('personnel_type_id')->references('id')->on('personnel_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('parishes', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('miscellaneous_listings', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('seminaries', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('vicarates', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Affiliations', function(Blueprint $table) {
			$table->foreign('affiliation_type_id')->references('id')->on('affiliation_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Affiliations', function(Blueprint $table) {
			$table->foreign('religious_grouping_id')->references('id')->on('religious_groupings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clergies', function(Blueprint $table) {
			$table->foreign('personnel_id')->references('id')->on('personnels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clergies', function(Blueprint $table) {
			$table->foreign('affiliation_id')->references('id')->on('Affiliations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->foreign('year_id')->references('id')->on('years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('commissions', function(Blueprint $table) {
			$table->dropForeign('commissions_westoyv_id_foreign');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->dropForeign('assignments_personnel_id_foreign');
		});
		Schema::table('assignments', function(Blueprint $table) {
			$table->dropForeign('assignments_position_id_foreign');
		});
		Schema::table('personnels', function(Blueprint $table) {
			$table->dropForeign('personnels_personnel_type_id_foreign');
		});
		Schema::table('parishes', function(Blueprint $table) {
			$table->dropForeign('parishes_location_id_foreign');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->dropForeign('institutes_location_id_foreign');
		});
		Schema::table('miscellaneous_listings', function(Blueprint $table) {
			$table->dropForeign('miscellaneous_listings_location_id_foreign');
		});
		Schema::table('seminaries', function(Blueprint $table) {
			$table->dropForeign('seminaries_location_id_foreign');
		});
		Schema::table('vicarates', function(Blueprint $table) {
			$table->dropForeign('vicarates_location_id_foreign');
		});
		Schema::table('Affiliations', function(Blueprint $table) {
			$table->dropForeign('Affiliations_affiliation_type_id_foreign');
		});
		Schema::table('Affiliations', function(Blueprint $table) {
			$table->dropForeign('Affiliations_religious_grouping_id_foreign');
		});
		Schema::table('clergies', function(Blueprint $table) {
			$table->dropForeign('clergies_personnel_id_foreign');
		});
		Schema::table('clergies', function(Blueprint $table) {
			$table->dropForeign('clergies_affiliation_id_foreign');
		});
		Schema::table('schedules', function(Blueprint $table) {
			$table->dropForeign('schedules_year_id_foreign');
		});
	}
}