<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model 
{

    protected $table = 'customers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function addresses()
    {
        return $this->hasMany('Address');
    }

    public function mainAddress()
    {
        return $this->hasOne('Address');
    }

}