<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function addresses()
	{
		return $this->hasMany('Address');
	}

	public function mainAddress()
	{
		return $this->hasOne('Address');
	}

}