<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title')->nullable();
			$table->string('ext')->nullable();
			$table->string('type')->nullable();
			$table->string('description');
			$table->tinyInteger('is_active')->default('0');
			$table->string('path')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}