<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMealsTable extends Migration {

	public function up()
	{
		Schema::create('meals', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->decimal('price', 6,2);
			$table->decimal('offer_price');
			$table->string('image');
			$table->bigInteger('restaurant_id')->unsigned();
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('meals');
	}
}