<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeeQualificationTable extends Migration {

	public function up()
	{
		Schema::create('employee_qualification', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('employee_id')->unsigned();
			$table->bigInteger('qualification_id')->unsigned();
			$table->datetime('qualification_date');
			$table->enum('qualification_round', array('first', 'second'));
			$table->string('qualification_degree');
			$table->string('qualification_major');
			$table->string('qualification_source');
		});
	}

	public function down()
	{
		Schema::drop('employee_qualification');
	}
}