<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->float('exemption_from_shipping_cost')->nullable();
			$table->float('minimum_order_to_show_gifts')->nullable();
			$table->string('image', 191)->nullable();
			$table->string('currency_exchange_rate', 191);
			$table->enum('status', array('avtive', 'closed'));
			$table->string('currency', 191);
			$table->bigInteger('item_wrapping_price')->default('0');
			$table->bigInteger('delivery_time');
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}