<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountOpportunitiesTable extends Migration {

	public function up()
	{
		Schema::create('discount_opportunities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('country_id')->unsigned();
			$table->float('discount');
			$table->enum('status', array('active', 'closed'));
		});
	}

	public function down()
	{
		Schema::drop('discount_opportunities');
	}
}