<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('user_id')->unsigned();
			$table->text('token')->nullable();
			$table->enum('status', array('in_progress', 'delivery', 'delivered', 'cancelled', 'returned'))->nullable();
			$table->float('item_discount')->nullable();
			$table->bigInteger('tax')->nullable();
			$table->float('tax_amount')->nullable();
			$table->float('shipping')->nullable();
			$table->double('total')->nullable();
			$table->string('coupon', 191)->nullable();
			$table->bigInteger('coupon_id')->unsigned();
			$table->enum('payment_type', array('cash', 'wallet', 'online'))->nullable();
			$table->timestamp('payment_at')->nullable();
			$table->timestamp('cancelled_at')->nullable();
			$table->timestamp('delivered_at')->nullable();
			$table->float('currency_exchange_rate')->nullable();
			$table->bigInteger('country_id')->unsigned();
			$table->boolean('receipt_from_branch')->default(0);
			$table->text('address')->nullable();
			$table->decimal('latitude')->nullable();
			$table->decimal('longitude')->nullable();
			$table->string('city', 191)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}