<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');

	public function sub_categories()
	{
		return $this->hasMany('Models\Category');
	}

	public function brands()
	{
		return $this->hasMany('Models\Brand');
	}

	public function products()
	{
		return $this->belongsToMany('Models\Product');
	}

}