<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CountryAdmin extends Eloquent {

	protected $table = 'country_admins';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id', 'country_role_id', 'country_code', 'phone', 'email', 'password', 'image', 'active', 'block', 'type');

	public function country()
	{
		return $this->belongsTo('Models\Country');
	}

	public function country_role()
	{
		return $this->hasOne('Models\CountryRole');
	}

}