<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'meta_details', 'description', 'price', 'discount', 'image', 'quantity', 'start_at', 'brand_id', 'published_at', 'end_at', 'badge_id', 'coupon_id', 'country_id', 'soon', 'out_of_stock');

	public function brand()
	{
		return $this->belongsTo('Models\Brand');
	}

	public function productReviews()
	{
		return $this->hasMany('Models\ProductReview');
	}

	public function tags()
	{
		return $this->hasMany('Models\Tag');
	}

	public function categories()
	{
		return $this->belongsToMany('Models\Category');
	}

	public function sub_categories()
	{
		return $this->belongsToMany('Models\SubCategory');
	}

	public function images()
	{
		return $this->hasMany('Models\ProductImage');
	}

	public function sizes()
	{
		return $this->belongsToMany('Models\Size');
	}

	public function badge()
	{
		return $this->hasOne('Models\Badge');
	}

	public function excludedProductCountries()
	{
		return $this->hasMany('Models\ExcludedProductCountry');
	}

	public function coupon()
	{
		return $this->belongsTo('Models\Coupon');
	}

}