<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SubCategory extends Eloquent {

	protected $table = 'sub_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'meta_details', 'category_id');

	public function category()
	{
		return $this->belongsTo('Models\Category');
	}

	public function products()
	{
		return $this->belongsToMany('Models\Product');
	}

}