<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('MEETING_issues', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('MEETING_meeting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_tasks', function(Blueprint $table) {
			$table->foreign('issue_id')->references('id')->on('MEETING_issues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_groups', function(Blueprint $table) {
			$table->foreign('proprietary_id')->references('id')->on('AA_personas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_group_AA_persona', function(Blueprint $table) {
			$table->foreign('persona_id')->references('id')->on('AA_personas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_group_AA_persona', function(Blueprint $table) {
			$table->foreign('group_id')->references('id')->on('MEETING_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_meeting_AA_persona', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('MEETING_meeting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_meeting_AA_persona', function(Blueprint $table) {
			$table->foreign('persona_id')->references('id')->on('AA_personas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_accords', function(Blueprint $table) {
			$table->foreign('issue_id')->references('id')->on('MEETING_issues')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('MEETING_file', function(Blueprint $table) {
			$table->foreign('meeting_id')->references('id')->on('MEETING_meeting')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('MEETING_issues', function(Blueprint $table) {
			$table->dropForeign('MEETING_issues_meeting_id_foreign');
		});
		Schema::table('MEETING_tasks', function(Blueprint $table) {
			$table->dropForeign('MEETING_tasks_issue_id_foreign');
		});
		Schema::table('MEETING_groups', function(Blueprint $table) {
			$table->dropForeign('MEETING_groups_proprietary_id_foreign');
		});
		Schema::table('MEETING_group_AA_persona', function(Blueprint $table) {
			$table->dropForeign('MEETING_group_AA_persona_persona_id_foreign');
		});
		Schema::table('MEETING_group_AA_persona', function(Blueprint $table) {
			$table->dropForeign('MEETING_group_AA_persona_group_id_foreign');
		});
		Schema::table('MEETING_meeting_AA_persona', function(Blueprint $table) {
			$table->dropForeign('MEETING_meeting_AA_persona_meeting_id_foreign');
		});
		Schema::table('MEETING_meeting_AA_persona', function(Blueprint $table) {
			$table->dropForeign('MEETING_meeting_AA_persona_persona_id_foreign');
		});
		Schema::table('MEETING_accords', function(Blueprint $table) {
			$table->dropForeign('MEETING_accords_issue_id_foreign');
		});
		Schema::table('MEETING_file', function(Blueprint $table) {
			$table->dropForeign('MEETING_file_meeting_id_foreign');
		});
	}
}