<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReactionsTable extends Migration {

	public function up()
	{
		Schema::create('reactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('reactionable_type', array('post', 'comment'));
			$table->bigInteger('reactionable_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('reactions');
	}
}