<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleryImagesTable extends Migration {

	public function up()
	{
		Schema::create('gallery_images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug', 191)->unique();
			$table->text('image_name')->nullable();
			$table->string('alt_text', 191)->nullable();
			$table->tinyInteger('is_trashed')->nullable();
			$table->tinyInteger('created_by')->nullable();
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('gallery_images');
	}
}