<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantTable extends Migration {

	public function up()
	{
		Schema::create('restaurant', function(Blueprint $table) {
			$table->increments('id');
			$table->string('manager_identity');
			$table->time('start_work');
			$table->time('end_work');
			$table->json('off_days');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurant');
	}
}