<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSourcesTable extends Migration {

	public function up()
	{
		Schema::create('sources', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned()->nullable()->default('null');
			$table->integer('media_id')->unsigned();
			$table->string('name');
			$table->string('public_name');
			$table->string('source_type');
			$table->text('request_parameters_json')->nullable();
			$table->integer('update_rythm')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sources');
	}
}