<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateArToursTable extends Migration {

	public function up()
	{
		Schema::create('ar_tours', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('latlng');
			$table->string('audio_path');
			$table->string('audio_caption_path');
			$table->string('video_path');
			$table->string('video_caption_path');
			$table->json('quiz')->default('{}');
			$table->string('vr360_xml_path');
			$table->string('title');
			$table->text('description');
			$table->bigInteger('poi_id')->unsigned();
			$table->bigInteger('gallery_id')->unsigned();
			$table->json('i18n');
			$table->string('arkit_path');
			$table->string('arcore_path');
		});
	}

	public function down()
	{
		Schema::drop('ar_tours');
	}
}