<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBadgesTable extends Migration {

	public function up()
	{
		Schema::create('badges', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('title');
			$table->string('icon_path');
			$table->enum('status', array('published', 'unpublished'));
			$table->json('i18n');
		});
	}

	public function down()
	{
		Schema::drop('badges');
	}
}