<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBannersTable extends Migration {

	public function up()
	{
		Schema::create('banners', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('lang', 2);
			$table->string('image_path');
			$table->enum('status', array('published', 'unpublished'));
			$table->datetime('expires')->nullable();
			$table->datetime('starts');
			$table->string('url');
			$table->string('mode');
		});
	}

	public function down()
	{
		Schema::drop('banners');
	}
}