<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGalleryImagesTable extends Migration {

	public function up()
	{
		Schema::create('gallery_images', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->string('path');
			$table->integer('width');
			$table->integer('height');
			$table->string('alt', 255);
			$table->text('description');
			$table->bigInteger('gallery_id')->unsigned();
			$table->json('i18n');
		});
	}

	public function down()
	{
		Schema::drop('gallery_images');
	}
}