<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncidenciasTable extends Migration {

	public function up()
	{
		Schema::create('incidencias', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->smallInteger('nomina_anio');
			$table->smallInteger('nomina_id');
			$table->smallInteger('empresa_id');
			$table->smallInteger('empleado_id');
			$table->char('apellido_paterno', 40);
			$table->char('apellido_materno', 40);
			$table->char('nombre_empleado', 40);
			$table->decimal('otros_ingresos');
			$table->decimal('descto_faltas');
			$table->decimal('descto_fonacot');
			$table->decimal('descto_infonavit');
			$table->decimal('otros_descuentos');
		});
	}

	public function down()
	{
		Schema::drop('incidencias');
	}
}