<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function SubCategory()
	{
		return $this->belongsTo('SubCategory');
	}

	public function Category()
	{
		return $this->belongsTo('Category');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

}