<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeadsTable extends Migration {

	public function up()
	{
		Schema::create('leads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('1', '2'));
			$table->mediumInteger('client_id')->nullable();
			$table->mediumInteger('owner_id');
			$table->mediumInteger('phase_id');
			$table->mediumInteger('marketing_channel_id');
			$table->mediumInteger('communication_method_id');
			$table->longText('note');
			$table->string('campaign_name')->nullable();
			$table->string('referred_by')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('leads');
	}
}