<?php

namespace Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Type extends Eloquent {

	protected $table = 'types';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function property_specification()
	{
		return $this->belongsToMany('PropertySpecification', 'type_id');
	}

	public function type()
	{
		return $this->belongsTo('Type', 'type_id');
	}

}