<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTokensTable extends Migration {

	public function up()
	{
		Schema::create('user_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->text('token')->nullable();
			$table->enum('status', array('connected', 'disconnected'))->nullable();
			$table->enum('device_type', array('ios', 'android'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_tokens');
	}
}