<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;

class FoodCategory extends Model 
{

    protected $table = 'food_categories';
    public $timestamps = true;
    protected $fillable = array('name', 'type');

    public function places()
    {
        return $this->belongsToMany('Models\Place', 'places_categories', 'category_id', 'place_id');
    }

    public function foods()
    {
        return $this->hasMany('Food', 'category_id');
    }

}