<?php

namespace Models;

class Food extends Eloquent {

	protected $table = 'foods';
	public $timestamps = true;
	protected $fillable = array('name', 'category_id', 'place_id', 'logo', 'description', 'price');

	public function category()
	{
		return $this->belongsTo('Models\FoodCategory', 'category_id');
	}

	public function place()
	{
		return $this->belongsTo('Models\Place', 'place_id');
	}

	public function favourite_users()
	{
		return $this->belongsToMany('\User', 'favourites', 'food_id', 'user_id');
	}

	public function rate_users()
	{
		return $this->belongsToMany('\User', 'rates', 'food_id', 'food_id');
	}

	public function slides()
	{
		return $this->hasMany('Models\FoodSlider', 'food_id');
	}

}