<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->foreign('day_off_id')->references('id')->on('day_offs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviewables', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('favouriables', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carables', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('cars')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cars_show_rooms', function(Blueprint $table) {
			$table->foreign('day_off_id')->references('id')->on('day_offs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cars_show_rooms', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_offices', function(Blueprint $table) {
			$table->foreign('day_off_id')->references('id')->on('day_offs')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_offices', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_cars', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_cars', function(Blueprint $table) {
			$table->foreign('rental_office_id')->references('id')->on('rental_offices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_cars_reservation', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('rental_cars_reservation', function(Blueprint $table) {
			$table->foreign('rental_car_id')->references('id')->on('rental_cars')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categorizables', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('selling_special_numbers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->foreign('special_number_category_id')->references('id')->on('special_numbers_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->foreign('selling_special_number_id')->references('id')->on('selling_special_numbers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_number_reservations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_number_reservations', function(Blueprint $table) {
			$table->foreign('special_number_id')->references('id')->on('special_numbers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('garages', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('winches', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('winch_reservations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('winch_reservations', function(Blueprint $table) {
			$table->foreign('winch_id')->references('id')->on('winches')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_numbers_verifications', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('special_numbers_verifications', function(Blueprint $table) {
			$table->foreign('special_number_id')->references('id')->on('special_numbers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_section_id_foreign');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->dropForeign('agencies_country_id_foreign');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->dropForeign('agencies_brand_id_foreign');
		});
		Schema::table('agencies', function(Blueprint $table) {
			$table->dropForeign('agencies_day_off_id_foreign');
		});
		Schema::table('reviewables', function(Blueprint $table) {
			$table->dropForeign('reviewables_user_id_foreign');
		});
		Schema::table('favouriables', function(Blueprint $table) {
			$table->dropForeign('favouriables_user_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_category_id_foreign');
		});
		Schema::table('carables', function(Blueprint $table) {
			$table->dropForeign('carables_car_id_foreign');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->dropForeign('areas_city_id_foreign');
		});
		Schema::table('cars_show_rooms', function(Blueprint $table) {
			$table->dropForeign('cars_show_rooms_day_off_id_foreign');
		});
		Schema::table('cars_show_rooms', function(Blueprint $table) {
			$table->dropForeign('cars_show_rooms_country_id_foreign');
		});
		Schema::table('rental_offices', function(Blueprint $table) {
			$table->dropForeign('rental_offices_day_off_id_foreign');
		});
		Schema::table('rental_offices', function(Blueprint $table) {
			$table->dropForeign('rental_offices_country_id_foreign');
		});
		Schema::table('rental_cars', function(Blueprint $table) {
			$table->dropForeign('rental_cars_brand_id_foreign');
		});
		Schema::table('rental_cars', function(Blueprint $table) {
			$table->dropForeign('rental_cars_rental_office_id_foreign');
		});
		Schema::table('rental_cars_reservation', function(Blueprint $table) {
			$table->dropForeign('rental_cars_reservation_user_id_foreign');
		});
		Schema::table('rental_cars_reservation', function(Blueprint $table) {
			$table->dropForeign('rental_cars_reservation_rental_car_id_foreign');
		});
		Schema::table('categorizables', function(Blueprint $table) {
			$table->dropForeign('categorizables_category_id_foreign');
		});
		Schema::table('selling_special_numbers', function(Blueprint $table) {
			$table->dropForeign('selling_special_numbers_country_id_foreign');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->dropForeign('special_numbers_special_number_category_id_foreign');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->dropForeign('special_numbers_selling_special_number_id_foreign');
		});
		Schema::table('special_numbers', function(Blueprint $table) {
			$table->dropForeign('special_numbers_user_id_foreign');
		});
		Schema::table('special_number_reservations', function(Blueprint $table) {
			$table->dropForeign('special_number_reservations_user_id_foreign');
		});
		Schema::table('special_number_reservations', function(Blueprint $table) {
			$table->dropForeign('special_number_reservations_special_number_id_foreign');
		});
		Schema::table('garages', function(Blueprint $table) {
			$table->dropForeign('garages_country_id_foreign');
		});
		Schema::table('winches', function(Blueprint $table) {
			$table->dropForeign('winches_country_id_foreign');
		});
		Schema::table('winch_reservations', function(Blueprint $table) {
			$table->dropForeign('winch_reservations_user_id_foreign');
		});
		Schema::table('winch_reservations', function(Blueprint $table) {
			$table->dropForeign('winch_reservations_winch_id_foreign');
		});
		Schema::table('special_numbers_verifications', function(Blueprint $table) {
			$table->dropForeign('special_numbers_verifications_user_id_foreign');
		});
		Schema::table('special_numbers_verifications', function(Blueprint $table) {
			$table->dropForeign('special_numbers_verifications_special_number_id_foreign');
		});
	}
}