<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewablesTable extends Migration {

	public function up()
	{
		Schema::create('reviewables', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('reviewable_type');
			$table->bigInteger('reviewable_id');
			$table->bigInteger('user_id')->unsigned();
			$table->float('rate', 1,2)->nullable();
			$table->text('comment')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviewables');
	}
}