<?php

namespace App\Models;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;
	protected $fillable = array('id', 'name_ar', 'name_en', 'section_id', 'timestamps');

	public function section()
	{
		return $this->belongsTo('App\Models\Section');
	}

	public function agencies()
	{
		return $this->morphedByMany('App\Models\Agency', 'categorizable');
	}

	public function show_rooms()
	{
		return $this->morphedByMany('App\Models\CarsShowRoom', 'categorizable');
	}

	public function rental_offices()
	{
		return $this->morphedByMany('App\Models\RentalOffice', 'categorizable');
	}

	public function garages()
	{
		return $this->morphedByMany('App\Models\Garage', 'categorizable');
	}

	public function branches()
	{
		return $this->hasMany('App\Models\Branch');
	}

}