<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('id', 'first_name', 'email_verified_at', 'password', 'remember_token', 'timestamps');

	public function agencies_reviews()
	{
		return $this->morphedByMany('App\Models\Agency', 'reviewable');
	}

	public function agencies_favourites()
	{
		return $this->morphedByMany('App\Models\Agency', 'favouriable');
	}

	public function show_rooms_reviews()
	{
		return $this->morphedByMany('App\Models\CarsShowRoom', 'reviewable');
	}

	public function show_rooms_favourites()
	{
		return $this->morphedByMany('App\Models\CarsShowRoom', 'favouriable');
	}

	public function agency_check_reservations()
	{
		return $this->morphedByMany('App\Models\Agency', 'checkable');
	}

	public function show_rooms__check_reservation()
	{
		return $this->morphedByMany('App\Models\CarsShowRoom', 'checkable');
	}

	public function rental_offices_reviews()
	{
		return $this->morphedByMany('App\Models\RentalOffice', 'reviewable');
	}

	public function rental_offices_favourites()
	{
		return $this->morphedByMany('App\Models\RentalOffice', 'favouriable');
	}

	public function rental_car_reservations()
	{
		return $this->hasMany('App\Models\RentalCarsReservation');
	}

	public function selling_special_numbers_reviews()
	{
		return $this->morphedByMany('App\Models\SellingSpecialNumber', 'reviewable');
	}

	public function selling_special_numbers_favourites()
	{
		return $this->morphedByMany('App\Models\SellingSpecialNumber', 'favouriable');
	}

	public function special_numbers()
	{
		return $this->hasMany('App\Models\SpecialNumber');
	}

	public function special_number_reservations()
	{
		return $this->hasMany('App\Models\SpecialNumberReservation');
	}

	public function garages_favourites()
	{
		return $this->morphedByMany('App\Models\Garage', 'favouriable');
	}

	public function garges_reviews()
	{
		return $this->morphedByMany('App\Models\Garage', 'reviewable');
	}

	public function winches_reviews()
	{
		return $this->morphedByMany('App\Models\Winch', 'reviewable');
	}

	public function wiches_favourites()
	{
		return $this->morphedByMany('App\Models\Winch', 'favouriable');
	}

	public function winch_reservation()
	{
		return $this->hasMany('App\Models\WinchReservation');
	}

	public function verifications()
	{
		return $this->belongsToMany('App\Models\SpecialNumber', 'special_numbers_verifications');
	}

}