<?php

namespace App\Models;

class Employee extends Eloquent {

	protected $table = 'employees';
	public $timestamps = true;

	public function resturantSection()
	{
		return $this->belongsTo('App\Models\ResturantSection');
	}

	public function region()
	{
		return $this->belongsTo('App\Models\Region');
	}

	public function shifts()
	{
		return $this->belongsToMany('App\Models\Shift');
	}

	public function attandances()
	{
		return $this->hasMany('App\Models\Attendance');
	}

	public function performances()
	{
		return $this->hasMany('App\Models\EmployeePerformance');
	}

	public function deliveries()
	{
		return $this->hasMany('App\Models\Delivery');
	}

	public function resturant()
	{
		return $this->belongsTo('App\Models\Resturant');
	}

}